//#################################################################
//	Misc.cpp : implementation file
//
//#################################################################
#include "stdafx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "misc.h"
#include "Comm.h"
#include "GlobalVar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define DIB_HEADER_MARKER   ((WORD) ('M' << 8) | 'B')

//#################################################################
// S_WORD()	:	Combine two bytes to WORD
//#################################################################
unsigned short S_WORD(char LByte,char HByte)
{
unsigned short	Value=0;
unsigned short 	T_LByte;
unsigned short 	T_HByte;

T_LByte=LByte;	T_LByte=T_LByte&0xff;
T_HByte=HByte;	T_HByte=T_HByte&0xff;

Value=T_HByte<<8;
Value=Value|T_LByte;

return ( Value );
}

//#################################################################
// S_WordTo2Bytes()	:	Splite WORD to 2 bytes.
//#################################################################
void S_WordTo2Bytes(unsigned short Num,unsigned char *LByte,
					unsigned char *HByte)
{

*LByte=(BYTE) (Num&0xff);
*HByte=(BYTE) (Num>>8);

}

//#################################################################
// LoadBitmapFromBMPFile()	:	
//#################################################################
BOOL LoadBitmapFromBMPFile( LPTSTR szFileName, HBITMAP *phBitmap,
   HPALETTE *phPalette )
{

   BITMAP  bm;

   *phBitmap = NULL;
   *phPalette = NULL;

   // Use LoadImage() to get the image loaded into a DIBSection
   *phBitmap = (HBITMAP) LoadImage( NULL, szFileName, IMAGE_BITMAP, 0, 0,
               LR_CREATEDIBSECTION | LR_DEFAULTSIZE | LR_LOADFROMFILE );
   if( *phBitmap == NULL )
     return FALSE;

   // Get the color depth of the DIBSection
   GetObject(*phBitmap, sizeof(BITMAP), &bm );
   // If the DIBSection is 256 color or less, it has a color table
   if( ( bm.bmBitsPixel * bm.bmPlanes ) <= 8 )
   {
   HDC           hMemDC;
   HBITMAP       hOldBitmap;
   RGBQUAD       rgb[256];
   LPLOGPALETTE  pLogPal;
   WORD          i;

   // Create a memory DC and select the DIBSection into it
   hMemDC = CreateCompatibleDC( NULL );
   hOldBitmap =(HBITMAP) SelectObject( hMemDC, *phBitmap );
   // Get the DIBSection's color table
   GetDIBColorTable( hMemDC, 0, 256, rgb );
   // Create a palette from the color tabl
   pLogPal = (LPLOGPALETTE) malloc( sizeof(LOGPALETTE) + (256*sizeof(PALETTEENTRY)) );
   pLogPal->palVersion = 0x300;
   pLogPal->palNumEntries = 256;
   for(i=0;i<256;i++)
   {
     pLogPal->palPalEntry[i].peRed = rgb[i].rgbRed;
     pLogPal->palPalEntry[i].peGreen = rgb[i].rgbGreen;
     pLogPal->palPalEntry[i].peBlue = rgb[i].rgbBlue;
     pLogPal->palPalEntry[i].peFlags = 0;
   }
   *phPalette = CreatePalette( pLogPal );
   // Clean up
   free( pLogPal );
   SelectObject( hMemDC, hOldBitmap );
   DeleteDC( hMemDC );
   }
   else   // It has no color table, so use a halftone palette
   {
   HDC    hRefDC;

   hRefDC = GetDC( NULL );
   *phPalette = CreateHalftonePalette( hRefDC );
   ReleaseDC( NULL, hRefDC );
   }
   return TRUE;

} 


